﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Net;
using System.Net.Security;
using Microsoft.Samples.WindowsAzure.ServiceManagement;
using System.Threading;
using System.IO;
using System.Configuration;

namespace ServiceManagement
{
    public class ServiceManagementUtil
    {
        public static int PollTimeoutInSeconds = 30;
        static ServiceManagementUtil()
        {
            ServicePointManager.ServerCertificateValidationCallback = (RemoteCertificateValidationCallback)Delegate.Combine(ServicePointManager.ServerCertificateValidationCallback, new RemoteCertificateValidationCallback(ServiceManagementUtil.RemoteCertValidate));
        }


        public static X509Certificate2 GetCertificate(byte[] certificateBytes)
        {

            return new X509Certificate2(certificateBytes);


        }

        public static X509Certificate2 GetCertificate(string certificateFilePath)
        {

            return new X509Certificate2(certificateFilePath);


        }

        private static bool RemoteCertValidate(object sender, X509Certificate cert, X509Chain chain, SslPolicyErrors error)
        {
            return true;
        }

        private static IServiceManagement GetChannel(byte[] certificateBytes)
        {

            return ServiceManagementHelper.CreateServiceManagementChannel("WindowsAzureEndPoint", GetCertificate(certificateBytes));
        }

        private static IServiceManagement GetChannel()
        {

            return ServiceManagementHelper.CreateServiceManagementChannel("WindowsAzureEndPoint", GetCertificate());
        }

        private static void WaitForAsyncOperation(IServiceManagement service, string trackingId, string subscriptionId)
        {
            Operation operation;
            int num = 0;
            do
            {
                operation = service.GetOperationStatus(subscriptionId, trackingId);
                Thread.Sleep(30000);
                Console.Write(".");
                num++;
                if ((PollTimeoutInSeconds > 0) && (num > PollTimeoutInSeconds))
                {
                    Console.WriteLine();
                    Console.WriteLine("Giving up after {0} seconds. Call GetResult manually to get the status", PollTimeoutInSeconds);
                    break;
                }
            }
            while ((operation.Status != "Failed") && (operation.Status != "Succeeded"));
            if (operation.Status != "InProgress")
            {
                Console.WriteLine("Done");
            }
            Console.Write("Operation Status=" + operation.Status.ToString());
        }


        public static HostedServiceList ListHostedServices(ref IServiceManagement channel, string subscriptionId, byte[] certificateBytes, out string opid )
        {
            opid = string.Empty;
            HostedServiceList hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.ListHostedServices(subscriptionId);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;
                            
                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                Console.WriteLine("There was an error processing this command.");
            }

            return hl;
        }

        

        public static void ChangeConfiguration(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentName, string configFilePath, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        ChangeConfigurationInput input = new ChangeConfigurationInput();
                        input.Configuration = GetConfiguration(configFilePath);
                     
                        channel.ChangeConfiguration(subscriptionId, serviceName, deploymentName, input);
                       

                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

        }

        public static void ChangeConfigurationBySlot(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentSlot, string configFilePath, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        ChangeConfigurationInput input = new ChangeConfigurationInput();
                        input.Configuration = GetConfiguration(configFilePath);

                        channel.ChangeConfigurationBySlot(subscriptionId, serviceName,deploymentSlot , input);


                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

        }

        public static void CreateOrUpdateDeployment(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentName, string deploymentLabel, string configFileLocation, string deploymentSlot, string csPackageBlobUri, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                    
                }
                CreateDeploymentInput input2;
               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {


                    input2 = new CreateDeploymentInput();
                    input2.Name = deploymentName;
                    input2.Configuration = GetConfiguration(configFileLocation);
                    CreateDeploymentInput input = input2;
                    if (!string.IsNullOrEmpty(csPackageBlobUri))
                    {
                        input.PackageUrl = new Uri(csPackageBlobUri);
                    }
                    if (!string.IsNullOrEmpty(deploymentLabel))
                    {
                        input.Label = ServiceManagementHelper.EncodeToBase64String(deploymentLabel);
                    }

                    channel.CreateOrUpdateDeployment(subscriptionId, serviceName, deploymentSlot, input);
                    if (WebOperationContext.Current.IncomingResponse != null)
                    {

                        opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                        nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                        statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                    }



                }
            }
            catch (TimeoutException)
            {
                throw;
            }

        }

        public static void DeleteDeployment(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentName, byte[] certificateBytes, out string opid)
        {

            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        channel.DeleteDeployment(subscriptionId, serviceName, deploymentName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

           
        }

        public static void DeleteDeploymentBySlot(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentSlot, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

              
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        channel.DeleteDeploymentBySlot(subscriptionId, serviceName, deploymentSlot);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }
        }

        public static AffinityGroup GetAffinityGroup(ref IServiceManagement channel, string subscriptionId, string affinityGroupName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            AffinityGroup hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetAffinityGroup(subscriptionId, affinityGroupName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }


        public static Deployment GetDeployment(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            Deployment hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetDeployment(subscriptionId, serviceName, deploymentName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static Deployment GetDeploymentBySlot(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentSlot, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            Deployment hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetDeploymentBySlot(subscriptionId, serviceName, deploymentSlot);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;

        }

        public static HostedService GetHostedService(ref IServiceManagement channel, string subscriptionId, string serviceName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            HostedService hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetHostedService(subscriptionId, serviceName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                Console.WriteLine("There was an error processing this command.");
            }

            return hl;
        }

        public static HostedService GetHostedServiceWithDetails(ref IServiceManagement channel, string subscriptionId, string serviceName, bool embed_detail, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            HostedService hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetHostedServiceWithDetails(subscriptionId, serviceName, embed_detail);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static Operation GetOperationStatus(ref IServiceManagement channel, string subscriptionId, string operationId, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            Operation hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetOperationStatus(subscriptionId, operationId);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);

                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static StorageService GetStorageKeys(ref IServiceManagement channel, string subscriptionId, string serviceName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            StorageService hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetStorageKeys(subscriptionId, serviceName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);
                   
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static StorageService GetStorageService(ref IServiceManagement channel, string subscriptionId, string serviceName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            StorageService hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.GetStorageService(subscriptionId, serviceName);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static AffinityGroupList ListAffinityGroups(ref IServiceManagement channel, string subscriptionId, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            AffinityGroupList hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.ListAffinityGroups(subscriptionId);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static StorageServiceList ListStorageServices(ref IServiceManagement channel, string subscriptionId, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
            StorageServiceList hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

              
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        hl = channel.ListStorageServices(subscriptionId);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static StorageService RegenerateStorageServiceKeys(ref IServiceManagement channel, string subscriptionId, string serviceName, string keyType, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;

            StorageService hl = null;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        RegenerateKeys keys = new RegenerateKeys();
                        keys.KeyType = keyType;
 
                        hl = channel.RegenerateStorageServiceKeys(subscriptionId, serviceName, keys);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);

                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            return hl;
        }

        public static void SwapDeployment(ref IServiceManagement channel, string subscriptionId, string serviceName, string productionDeploymentName, string sourceDeploymentName, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;
           
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

               
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        SwapDeploymentInput input = new SwapDeploymentInput();
                        input.Production = productionDeploymentName;
                        input.SourceDeployment = sourceDeploymentName;
                        channel.SwapDeployment(subscriptionId, serviceName, input);
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }

                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);

                }
            }
            catch (TimeoutException)
            {
                throw;
            }

            
        }

        public static void UpdateDeploymentStatus(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentName, string deploymentStatus, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;

            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        UpdateDeploymentStatusInput input2 = new UpdateDeploymentStatusInput();
                        input2.Status = deploymentStatus;
                        UpdateDeploymentStatusInput input = input2;
                         channel.UpdateDeploymentStatus(subscriptionId,serviceName, deploymentName, input);
                      
                       
                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }

                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);

                }
            }
            catch (TimeoutException)
            {
                throw;
            }

        }

        public static void UpdateDeploymentStatusBySlot(ref IServiceManagement channel, string subscriptionId, string serviceName, string deploymentSlot, string deploymentStatus, byte[] certificateBytes, out string opid)
        {
            opid = string.Empty;

            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }

                
                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        UpdateDeploymentStatusInput input2 = new UpdateDeploymentStatusInput();
                        input2.Status = deploymentStatus;
                        UpdateDeploymentStatusInput input = input2;
                        channel.UpdateDeploymentStatusBySlot(subscriptionId, serviceName, deploymentSlot, input);


                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }

                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {

                    WaitForAsyncOperation(channel, opid, subscriptionId);

                }
            }
            catch (TimeoutException)
            {
                throw;
            }

        }

        public static void AddCertificate(ref IServiceManagement channel, string subscriptionId, string serviceName, byte[] certificateBytes, string cert_format, string cert_password, out string opid)
        {

            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }


                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        CertificateFile file2 = new CertificateFile();
                        file2.CertificateFormat = cert_format;
                        file2.Password = cert_password;
                        CertificateFile input = file2;
                        input.Data = Convert.ToBase64String(certificateBytes);
                        
                        channel.AddCertificates(subscriptionId, serviceName, input);

                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }


        }


        public static void DeleteCertificate(ref IServiceManagement channel, string subscriptionId, string serviceName, byte[] certificateBytes, string cert_algorithm, string cert_thumbprint, out string opid)
        {

            opid = string.Empty;
            try
            {
                if (channel == null)
                {
                    channel = GetChannel(certificateBytes);
                }


                HttpStatusCode? nullable = null;
                string statusDescription = null;
                using (new OperationContextScope((IContextChannel)channel))
                {
                    try
                    {
                        channel.DeleteCertificate(subscriptionId, serviceName, cert_algorithm, cert_thumbprint);


                        if (WebOperationContext.Current.IncomingResponse != null)
                        {

                            opid = WebOperationContext.Current.IncomingResponse.Headers["x-ms-request-id"];
                            nullable = new HttpStatusCode?(WebOperationContext.Current.IncomingResponse.StatusCode);
                            statusDescription = WebOperationContext.Current.IncomingResponse.StatusDescription;

                        }
                    }
                    catch (CommunicationException exception)
                    {
                        throw exception;
                    }
                    finally
                    {
                        if (nullable.HasValue)
                        {
                            Console.WriteLine("HTTP Status Code: {0}", nullable);
                            Console.WriteLine("StatusDescription: {0}", statusDescription);
                        }
                    }
                }

                if (((opid != null) && nullable.HasValue) && (((HttpStatusCode)nullable) == HttpStatusCode.Accepted))
                {
                    Console.WriteLine("Waiting for async operation to complete:");
                    WaitForAsyncOperation(channel, opid, subscriptionId);
                    Console.WriteLine();
                }
            }
            catch (TimeoutException)
            {
                throw;
            }


        }

        internal static string GetConfiguration(string configurationFile)
        {
            string configValue = null;
            try
            {
                configValue = string.Join("", File.ReadAllLines(Path.GetFullPath(configurationFile)));
            }
            catch (Exception)
            {
               
                throw;
            }
            return ServiceManagementHelper.EncodeToBase64String(configValue);
        }

        public static X509Certificate2 GetCertificate()
        {
            string thumbprint = ConfigurationManager.AppSettings["CertificateThumbprint"];
            if (string.IsNullOrEmpty(thumbprint))
            {
                Console.WriteLine("CertificateThumbprint cannot be found. Please check the config file. ");
                return null;
            }
            X509Store store = new X509Store(StoreName.My, StoreLocation.CurrentUser);
            store.Open(OpenFlags.ReadOnly);
            X509Certificate2Collection certificates = store.Certificates.Find(X509FindType.FindByThumbprint, thumbprint, false);
            if (certificates.Count != 1)
            {
                Console.WriteLine("Client certificate cannot be found. Please check the config file. ");
                return null;
            }
            return certificates[0];
            
        }



    }

}

